@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The configuration of the partition key to be used for partitioning data into multiple partitions
 * @property kind Indicates the kind of algorithm used for partitioning. For MultiHash, multiple partition keys (upto three maximum) are supported for container create
 * @property paths List of paths using which data within the container can be partitioned
 * @property systemKey Indicates if the container is using a system generated partition key
 * @property version Indicates the version of the partition key definition
 */
public data class ContainerPartitionKeyResponse(
    public val kind: String? = null,
    public val paths: List<String>? = null,
    public val systemKey: Boolean,
    public val version: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.ContainerPartitionKeyResponse): ContainerPartitionKeyResponse = ContainerPartitionKeyResponse(
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            paths = javaType.paths().map({ args0 -> args0 }),
            systemKey = javaType.systemKey(),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
