@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The object representing continuous mode backup policy.
 * @property continuousModeProperties Configuration values for continuous mode backup
 * @property migrationState The object representing the state of the migration between the backup policies.
 * @property type Describes the mode of backups.
 * Expected value is 'Continuous'.
 */
public data class ContinuousModeBackupPolicyResponse(
    public val continuousModeProperties: ContinuousModePropertiesResponse? = null,
    public val migrationState: BackupPolicyMigrationStateResponse? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.ContinuousModeBackupPolicyResponse): ContinuousModeBackupPolicyResponse = ContinuousModeBackupPolicyResponse(
            continuousModeProperties = javaType.continuousModeProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.ContinuousModePropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            migrationState = javaType.migrationState().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.BackupPolicyMigrationStateResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
