@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Connection string for the Cosmos DB account
 * @property connectionString Value of the connection string
 * @property description Description of the connection string
 * @property keyKind Kind of the connection string key
 * @property type Type of the connection string
 */
public data class DatabaseAccountConnectionStringResponse(
    public val connectionString: String,
    public val description: String,
    public val keyKind: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.DatabaseAccountConnectionStringResponse): DatabaseAccountConnectionStringResponse = DatabaseAccountConnectionStringResponse(
            connectionString = javaType.connectionString(),
            description = javaType.description(),
            keyKind = javaType.keyKind(),
            type = javaType.type(),
        )
    }
}
