@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.Suppress

/**
 * The metadata related to each access key for the given Cosmos DB database account.
 * @property primaryMasterKey The metadata related to the Primary Read-Write Key for the given Cosmos DB database account.
 * @property primaryReadonlyMasterKey The metadata related to the Primary Read-Only Key for the given Cosmos DB database account.
 * @property secondaryMasterKey The metadata related to the Secondary Read-Write Key for the given Cosmos DB database account.
 * @property secondaryReadonlyMasterKey The metadata related to the Secondary Read-Only Key for the given Cosmos DB database account.
 */
public data class DatabaseAccountKeysMetadataResponse(
    public val primaryMasterKey: AccountKeyMetadataResponse,
    public val primaryReadonlyMasterKey: AccountKeyMetadataResponse,
    public val secondaryMasterKey: AccountKeyMetadataResponse,
    public val secondaryReadonlyMasterKey: AccountKeyMetadataResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.DatabaseAccountKeysMetadataResponse): DatabaseAccountKeysMetadataResponse = DatabaseAccountKeysMetadataResponse(
            primaryMasterKey = javaType.primaryMasterKey().let({ args0 ->
                com.pulumi.azurenative.documentdb.kotlin.outputs.AccountKeyMetadataResponse.Companion.toKotlin(args0)
            }),
            primaryReadonlyMasterKey = javaType.primaryReadonlyMasterKey().let({ args0 ->
                com.pulumi.azurenative.documentdb.kotlin.outputs.AccountKeyMetadataResponse.Companion.toKotlin(args0)
            }),
            secondaryMasterKey = javaType.secondaryMasterKey().let({ args0 ->
                com.pulumi.azurenative.documentdb.kotlin.outputs.AccountKeyMetadataResponse.Companion.toKotlin(args0)
            }),
            secondaryReadonlyMasterKey = javaType.secondaryReadonlyMasterKey().let({ args0 ->
                com.pulumi.azurenative.documentdb.kotlin.outputs.AccountKeyMetadataResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
