@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The failover policy for a given region of a database account.
 * @property failoverPriority The failover priority of the region. A failover priority of 0 indicates a write region. The maximum value for a failover priority = (total number of regions - 1). Failover priority values must be unique for each of the regions in which the database account exists.
 * @property id The unique identifier of the region in which the database account replicates to. Example: &lt;accountName&gt;-&lt;locationName&gt;.
 * @property locationName The name of the region in which the database account exists.
 */
public data class FailoverPolicyResponse(
    public val failoverPriority: Int? = null,
    public val id: String,
    public val locationName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.FailoverPolicyResponse): FailoverPolicyResponse = FailoverPolicyResponse(
            failoverPriority = javaType.failoverPriority().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            locationName = javaType.locationName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
