@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Representation of a managed Cassandra cluster.
 * @property id The unique resource identifier of the ARM resource.
 * @property identity Identity for the resource.
 * @property location The location of the resource group to which the resource belongs.
 * @property name The name of the ARM resource.
 * @property properties Properties of a managed Cassandra cluster.
 * @property tags Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
 * @property type The type of Azure resource.
 */
public data class GetCassandraClusterResult(
    public val id: String,
    public val identity: ManagedCassandraManagedServiceIdentityResponse? = null,
    public val location: String? = null,
    public val name: String,
    public val properties: ClusterResourceResponseProperties,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.GetCassandraClusterResult): GetCassandraClusterResult = GetCassandraClusterResult(
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.ManagedCassandraManagedServiceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.documentdb.kotlin.outputs.ClusterResourceResponseProperties.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
