@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A managed Cassandra data center.
 * @property id The unique resource identifier of the database account.
 * @property name The name of the database account.
 * @property properties Properties of a managed Cassandra data center.
 * @property type The type of Azure resource.
 */
public data class GetCassandraDataCenterResult(
    public val id: String,
    public val name: String,
    public val properties: DataCenterResourceResponseProperties,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.GetCassandraDataCenterResult): GetCassandraDataCenterResult = GetCassandraDataCenterResult(
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.documentdb.kotlin.outputs.DataCenterResourceResponseProperties.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
