@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * An Azure Cosmos DB database account.
 * @property analyticalStorageConfiguration Analytical storage specific properties.
 * @property apiProperties API specific properties.
 * @property backupPolicy The object representing the policy for taking backups on an account.
 * @property capabilities List of Cosmos DB capabilities for the account
 * @property capacity The object that represents all properties related to capacity enforcement on an account.
 * @property connectorOffer The cassandra connector offer type for the Cosmos DB database C* account.
 * @property consistencyPolicy The consistency policy for the Cosmos DB database account.
 * @property cors The CORS policy for the Cosmos DB database account.
 * @property createMode Enum to indicate the mode of account creation.
 * @property databaseAccountOfferType The offer type for the Cosmos DB database account. Default value: Standard.
 * @property defaultIdentity The default identity for accessing key vault used in features like customer managed keys. The default identity needs to be explicitly set by the users. It can be "FirstPartyIdentity", "SystemAssignedIdentity" and more.
 * @property disableKeyBasedMetadataWriteAccess Disable write operations on metadata resources (databases, containers, throughput) via account keys
 * @property disableLocalAuth Opt-out of local authentication and ensure only MSI and AAD can be used exclusively for authentication.
 * @property documentEndpoint The connection endpoint for the Cosmos DB database account.
 * @property enableAnalyticalStorage Flag to indicate whether to enable storage analytics.
 * @property enableAutomaticFailover Enables automatic failover of the write region in the rare event that the region is unavailable due to an outage. Automatic failover will result in a new write region for the account and is chosen based on the failover priorities configured for the account.
 * @property enableCassandraConnector Enables the cassandra connector on the Cosmos DB C* account
 * @property enableFreeTier Flag to indicate whether Free Tier is enabled.
 * @property enableMultipleWriteLocations Enables the account to write in multiple locations
 * @property enablePartitionMerge Flag to indicate enabling/disabling of Partition Merge feature on the account
 * @property failoverPolicies An array that contains the regions ordered by their failover priorities.
 * @property id The unique resource identifier of the ARM resource.
 * @property identity Identity for the resource.
 * @property instanceId A unique identifier assigned to the database account
 * @property ipRules List of IpRules.
 * @property isVirtualNetworkFilterEnabled Flag to indicate whether to enable/disable Virtual Network ACL rules.
 * @property keyVaultKeyUri The URI of the key vault
 * @property keysMetadata The object that represents the metadata for the Account Keys of the Cosmos DB account.
 * @property kind Indicates the type of database account. This can only be set at database account creation.
 * @property location The location of the resource group to which the resource belongs.
 * @property locations An array that contains all of the locations enabled for the Cosmos DB account.
 * @property minimalTlsVersion Indicates the minimum allowed Tls version. The default value is Tls 1.2. Cassandra and Mongo APIs only work with Tls 1.2.
 * @property name The name of the ARM resource.
 * @property networkAclBypass Indicates what services are allowed to bypass firewall checks.
 * @property networkAclBypassResourceIds An array that contains the Resource Ids for Network Acl Bypass for the Cosmos DB account.
 * @property privateEndpointConnections List of Private Endpoint Connections configured for the Cosmos DB account.
 * @property provisioningState The status of the Cosmos DB account at the time the operation was called. The status can be one of following. 'Creating' – the Cosmos DB account is being created. When an account is in Creating state, only properties that are specified as input for the Create Cosmos DB account operation are returned. 'Succeeded' – the Cosmos DB account is active for use. 'Updating' – the Cosmos DB account is being updated. 'Deleting' – the Cosmos DB account is being deleted. 'Failed' – the Cosmos DB account failed creation. 'DeletionFailed' – the Cosmos DB account deletion failed.
 * @property publicNetworkAccess Whether requests from Public Network are allowed
 * @property readLocations An array that contains of the read locations enabled for the Cosmos DB account.
 * @property restoreParameters Parameters to indicate the information about the restore.
 * @property systemData The system meta data relating to this resource.
 * @property tags Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
 * @property type The type of Azure resource.
 * @property virtualNetworkRules List of Virtual Network ACL rules configured for the Cosmos DB account.
 * @property writeLocations An array that contains the write location for the Cosmos DB account.
 */
public data class GetDatabaseAccountResult(
    public val analyticalStorageConfiguration: AnalyticalStorageConfigurationResponse? = null,
    public val apiProperties: ApiPropertiesResponse? = null,
    public val backupPolicy: Either<ContinuousModeBackupPolicyResponse, PeriodicModeBackupPolicyResponse>? = null,
    public val capabilities: List<CapabilityResponse>? = null,
    public val capacity: CapacityResponse? = null,
    public val connectorOffer: String? = null,
    public val consistencyPolicy: ConsistencyPolicyResponse? = null,
    public val cors: List<CorsPolicyResponse>? = null,
    public val createMode: String? = null,
    public val databaseAccountOfferType: String,
    public val defaultIdentity: String? = null,
    public val disableKeyBasedMetadataWriteAccess: Boolean? = null,
    public val disableLocalAuth: Boolean? = null,
    public val documentEndpoint: String,
    public val enableAnalyticalStorage: Boolean? = null,
    public val enableAutomaticFailover: Boolean? = null,
    public val enableCassandraConnector: Boolean? = null,
    public val enableFreeTier: Boolean? = null,
    public val enableMultipleWriteLocations: Boolean? = null,
    public val enablePartitionMerge: Boolean? = null,
    public val failoverPolicies: List<FailoverPolicyResponse>,
    public val id: String,
    public val identity: ManagedServiceIdentityResponse? = null,
    public val instanceId: String,
    public val ipRules: List<IpAddressOrRangeResponse>? = null,
    public val isVirtualNetworkFilterEnabled: Boolean? = null,
    public val keyVaultKeyUri: String? = null,
    public val keysMetadata: DatabaseAccountKeysMetadataResponse,
    public val kind: String? = null,
    public val location: String? = null,
    public val locations: List<LocationResponse>,
    public val minimalTlsVersion: String? = null,
    public val name: String,
    public val networkAclBypass: String? = null,
    public val networkAclBypassResourceIds: List<String>? = null,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>,
    public val provisioningState: String,
    public val publicNetworkAccess: String? = null,
    public val readLocations: List<LocationResponse>,
    public val restoreParameters: RestoreParametersResponse? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val virtualNetworkRules: List<VirtualNetworkRuleResponse>? = null,
    public val writeLocations: List<LocationResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.GetDatabaseAccountResult): GetDatabaseAccountResult = GetDatabaseAccountResult(
            analyticalStorageConfiguration = javaType.analyticalStorageConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.AnalyticalStorageConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            apiProperties = javaType.apiProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.ApiPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            backupPolicy = javaType.backupPolicy().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.documentdb.kotlin.outputs.ContinuousModeBackupPolicyResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.documentdb.kotlin.outputs.PeriodicModeBackupPolicyResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            capabilities = javaType.capabilities().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.CapabilityResponse.Companion.toKotlin(args0)
                })
            }),
            capacity = javaType.capacity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.CapacityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            connectorOffer = javaType.connectorOffer().map({ args0 -> args0 }).orElse(null),
            consistencyPolicy = javaType.consistencyPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.ConsistencyPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            cors = javaType.cors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.CorsPolicyResponse.Companion.toKotlin(args0)
                })
            }),
            createMode = javaType.createMode().map({ args0 -> args0 }).orElse(null),
            databaseAccountOfferType = javaType.databaseAccountOfferType(),
            defaultIdentity = javaType.defaultIdentity().map({ args0 -> args0 }).orElse(null),
            disableKeyBasedMetadataWriteAccess = javaType.disableKeyBasedMetadataWriteAccess().map({ args0 ->
                args0
            }).orElse(null),
            disableLocalAuth = javaType.disableLocalAuth().map({ args0 -> args0 }).orElse(null),
            documentEndpoint = javaType.documentEndpoint(),
            enableAnalyticalStorage = javaType.enableAnalyticalStorage().map({ args0 -> args0 }).orElse(null),
            enableAutomaticFailover = javaType.enableAutomaticFailover().map({ args0 -> args0 }).orElse(null),
            enableCassandraConnector = javaType.enableCassandraConnector().map({ args0 -> args0 }).orElse(null),
            enableFreeTier = javaType.enableFreeTier().map({ args0 -> args0 }).orElse(null),
            enableMultipleWriteLocations = javaType.enableMultipleWriteLocations().map({ args0 ->
                args0
            }).orElse(null),
            enablePartitionMerge = javaType.enablePartitionMerge().map({ args0 -> args0 }).orElse(null),
            failoverPolicies = javaType.failoverPolicies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.FailoverPolicyResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            instanceId = javaType.instanceId(),
            ipRules = javaType.ipRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.IpAddressOrRangeResponse.Companion.toKotlin(args0)
                })
            }),
            isVirtualNetworkFilterEnabled = javaType.isVirtualNetworkFilterEnabled().map({ args0 ->
                args0
            }).orElse(null),
            keyVaultKeyUri = javaType.keyVaultKeyUri().map({ args0 -> args0 }).orElse(null),
            keysMetadata = javaType.keysMetadata().let({ args0 ->
                com.pulumi.azurenative.documentdb.kotlin.outputs.DatabaseAccountKeysMetadataResponse.Companion.toKotlin(args0)
            }),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            locations = javaType.locations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.LocationResponse.Companion.toKotlin(args0)
                })
            }),
            minimalTlsVersion = javaType.minimalTlsVersion().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            networkAclBypass = javaType.networkAclBypass().map({ args0 -> args0 }).orElse(null),
            networkAclBypassResourceIds = javaType.networkAclBypassResourceIds().map({ args0 -> args0 }),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            readLocations = javaType.readLocations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.LocationResponse.Companion.toKotlin(args0)
                })
            }),
            restoreParameters = javaType.restoreParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.RestoreParametersResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.documentdb.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            virtualNetworkRules = javaType.virtualNetworkRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.VirtualNetworkRuleResponse.Companion.toKotlin(args0)
                })
            }),
            writeLocations = javaType.writeLocations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.LocationResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
