@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents a mongo cluster firewall rule.
 * @property endIpAddress The end IP address of the mongo cluster firewall rule. Must be IPv4 format.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property name The name of the resource
 * @property provisioningState The provisioning state of the firewall rule.
 * @property startIpAddress The start IP address of the mongo cluster firewall rule. Must be IPv4 format.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetMongoClusterFirewallRuleResult(
    public val endIpAddress: String,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val startIpAddress: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.GetMongoClusterFirewallRuleResult): GetMongoClusterFirewallRuleResult = GetMongoClusterFirewallRuleResult(
            endIpAddress = javaType.endIpAddress(),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            startIpAddress = javaType.startIpAddress(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.documentdb.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
