@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Represents a mongo cluster resource.
 * @property administratorLogin The administrator's login for the mongo cluster.
 * @property clusterStatus A status of the mongo cluster.
 * @property connectionString The default mongo connection string for the cluster.
 * @property earliestRestoreTime Earliest restore timestamp in UTC ISO8601 format.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property nodeGroupSpecs The list of node group specs in the cluster.
 * @property provisioningState A provisioning state of the mongo cluster.
 * @property serverVersion The Mongo DB server version. Defaults to the latest available version if not specified.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetMongoClusterResult(
    public val administratorLogin: String? = null,
    public val clusterStatus: String,
    public val connectionString: String,
    public val earliestRestoreTime: String,
    public val id: String,
    public val location: String,
    public val name: String,
    public val nodeGroupSpecs: List<NodeGroupSpecResponse>? = null,
    public val provisioningState: String,
    public val serverVersion: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.GetMongoClusterResult): GetMongoClusterResult = GetMongoClusterResult(
            administratorLogin = javaType.administratorLogin().map({ args0 -> args0 }).orElse(null),
            clusterStatus = javaType.clusterStatus(),
            connectionString = javaType.connectionString(),
            earliestRestoreTime = javaType.earliestRestoreTime(),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            nodeGroupSpecs = javaType.nodeGroupSpecs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.NodeGroupSpecResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            serverVersion = javaType.serverVersion().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.documentdb.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
