@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Properties for the database account.
 * @property id The unique resource identifier of the database account.
 * @property name The name of the database account.
 * @property properties Services response resource.
 * @property type The type of Azure resource.
 */
public data class GetServiceResult(
    public val id: String,
    public val name: String,
    public val properties: Any,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.GetServiceResult): GetServiceResult = GetServiceResult(
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties(),
            type = javaType.type(),
        )
    }
}
