@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An Azure Cosmos DB Role Assignment
 * @property id The unique resource identifier of the database account.
 * @property name The name of the database account.
 * @property principalId The unique identifier for the associated AAD principal in the AAD graph to which access is being granted through this Role Assignment. Tenant ID for the principal is inferred using the tenant associated with the subscription.
 * @property roleDefinitionId The unique identifier for the associated Role Definition.
 * @property scope The data plane resource path for which access is being granted through this Role Assignment.
 * @property type The type of Azure resource.
 */
public data class GetSqlResourceSqlRoleAssignmentResult(
    public val id: String,
    public val name: String,
    public val principalId: String? = null,
    public val roleDefinitionId: String? = null,
    public val scope: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.GetSqlResourceSqlRoleAssignmentResult): GetSqlResourceSqlRoleAssignmentResult = GetSqlResourceSqlRoleAssignmentResult(
            id = javaType.id(),
            name = javaType.name(),
            principalId = javaType.principalId().map({ args0 -> args0 }).orElse(null),
            roleDefinitionId = javaType.roleDefinitionId().map({ args0 -> args0 }).orElse(null),
            scope = javaType.scope().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
