@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * An Azure Cosmos DB SQL Role Definition.
 * @property assignableScopes A set of fully qualified Scopes at or below which Role Assignments may be created using this Role Definition. This will allow application of this Role Definition on the entire database account or any underlying Database / Collection. Must have at least one element. Scopes higher than Database account are not enforceable as assignable Scopes. Note that resources referenced in assignable Scopes need not exist.
 * @property id The unique resource identifier of the database account.
 * @property name The name of the database account.
 * @property permissions The set of operations allowed through this Role Definition.
 * @property roleName A user-friendly name for the Role Definition. Must be unique for the database account.
 * @property type The type of Azure resource.
 */
public data class GetSqlResourceSqlRoleDefinitionResult(
    public val assignableScopes: List<String>? = null,
    public val id: String,
    public val name: String,
    public val permissions: List<PermissionResponse>? = null,
    public val roleName: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.GetSqlResourceSqlRoleDefinitionResult): GetSqlResourceSqlRoleDefinitionResult = GetSqlResourceSqlRoleDefinitionResult(
            assignableScopes = javaType.assignableScopes().map({ args0 -> args0 }),
            id = javaType.id(),
            name = javaType.name(),
            permissions = javaType.permissions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.PermissionResponse.Companion.toKotlin(args0)
                })
            }),
            roleName = javaType.roleName().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
