@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * An Azure Cosmos DB trigger.
 * @property id The unique resource identifier of the ARM resource.
 * @property location The location of the resource group to which the resource belongs.
 * @property name The name of the ARM resource.
 * @property resource
 * @property tags Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
 * @property type The type of Azure resource.
 */
public data class GetSqlResourceSqlTriggerResult(
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val resource: SqlTriggerGetPropertiesResponseResource? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.GetSqlResourceSqlTriggerResult): GetSqlResourceSqlTriggerResult = GetSqlResourceSqlTriggerResult(
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            resource = javaType.resource().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.SqlTriggerGetPropertiesResponseResource.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
