@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Resource for a regional service location.
 * @property graphApiComputeEndpoint The regional endpoint for GraphAPICompute.
 * @property location The location name.
 * @property name The regional service name.
 * @property status Describes the status of a service.
 */
public data class GraphAPIComputeRegionalServiceResourceResponse(
    public val graphApiComputeEndpoint: String,
    public val location: String,
    public val name: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.GraphAPIComputeRegionalServiceResourceResponse): GraphAPIComputeRegionalServiceResourceResponse =
            GraphAPIComputeRegionalServiceResourceResponse(
                graphApiComputeEndpoint = javaType.graphApiComputeEndpoint(),
                location = javaType.location(),
                name = javaType.name(),
                status = javaType.status(),
            )
    }
}
