@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties for GraphAPIComputeServiceResource.
 * @property creationTime Time of the last state change (ISO-8601 format).
 * @property graphApiComputeEndpoint GraphAPICompute endpoint for the service.
 * @property instanceCount Instance count for the service.
 * @property instanceSize Instance type for the service.
 * @property locations An array that contains all of the locations for the service.
 * @property serviceType ServiceType for the service.
 * Expected value is 'GraphAPICompute'.
 * @property status Describes the status of a service.
 */
public data class GraphAPIComputeServiceResourcePropertiesResponse(
    public val creationTime: String,
    public val graphApiComputeEndpoint: String? = null,
    public val instanceCount: Int? = null,
    public val instanceSize: String? = null,
    public val locations: List<GraphAPIComputeRegionalServiceResourceResponse>,
    public val serviceType: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.GraphAPIComputeServiceResourcePropertiesResponse): GraphAPIComputeServiceResourcePropertiesResponse =
            GraphAPIComputeServiceResourcePropertiesResponse(
                creationTime = javaType.creationTime(),
                graphApiComputeEndpoint = javaType.graphApiComputeEndpoint().map({ args0 -> args0 }).orElse(null),
                instanceCount = javaType.instanceCount().map({ args0 -> args0 }).orElse(null),
                instanceSize = javaType.instanceSize().map({ args0 -> args0 }).orElse(null),
                locations = javaType.locations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.documentdb.kotlin.outputs.GraphAPIComputeRegionalServiceResourceResponse.Companion.toKotlin(args0)
                    })
                }),
                serviceType = javaType.serviceType(),
                status = javaType.status(),
            )
    }
}
