@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The paths that are included in indexing
 * @property indexes List of indexes for this path
 * @property path The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
 * */
 */
public data class IncludedPathResponse(
    public val indexes: List<IndexesResponse>? = null,
    public val path: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.IncludedPathResponse): IncludedPathResponse = IncludedPathResponse(
            indexes = javaType.indexes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.IndexesResponse.Companion.toKotlin(args0)
                })
            }),
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
        )
    }
}
