@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The indexes for the path.
 * @property dataType The datatype for which the indexing behavior is applied to.
 * @property kind Indicates the type of index.
 * @property precision The precision of the index. -1 is maximum precision.
 */
public data class IndexesResponse(
    public val dataType: String? = null,
    public val kind: String? = null,
    public val precision: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.IndexesResponse): IndexesResponse = IndexesResponse(
            dataType = javaType.dataType().map({ args0 -> args0 }).orElse(null),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            precision = javaType.precision().map({ args0 -> args0 }).orElse(null),
        )
    }
}
