@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * IpAddressOrRange object
 * @property ipAddressOrRange A single IPv4 address or a single IPv4 address range in CIDR format. Provided IPs must be well-formatted and cannot be contained in one of the following ranges: 10.0.0.0/8, 100.64.0.0/10, 172.16.0.0/12, 192.168.0.0/16, since these are not enforceable by the IP address filter. Example of valid inputs: “23.40.210.245” or “23.40.210.0/8”.
 */
public data class IpAddressOrRangeResponse(
    public val ipAddressOrRange: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.IpAddressOrRangeResponse): IpAddressOrRangeResponse = IpAddressOrRangeResponse(
            ipAddressOrRange = javaType.ipAddressOrRange().map({ args0 -> args0 }).orElse(null),
        )
    }
}
