@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * The connection strings for the given mongo cluster.
 * @property connectionStrings An array that contains the connection strings for a mongo cluster.
 */
public data class ListMongoClusterConnectionStringsResult(
    public val connectionStrings: List<ConnectionStringResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.ListMongoClusterConnectionStringsResult): ListMongoClusterConnectionStringsResult = ListMongoClusterConnectionStringsResult(
            connectionStrings = javaType.connectionStrings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.ConnectionStringResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
