@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The connection info for the given notebook workspace
 * @property authToken Specifies auth token used for connecting to Notebook server (uses token-based auth).
 * @property notebookServerEndpoint Specifies the endpoint of Notebook server.
 */
public data class ListNotebookWorkspaceConnectionInfoResult(
    public val authToken: String,
    public val notebookServerEndpoint: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.ListNotebookWorkspaceConnectionInfoResult): ListNotebookWorkspaceConnectionInfoResult = ListNotebookWorkspaceConnectionInfoResult(
            authToken = javaType.authToken(),
            notebookServerEndpoint = javaType.notebookServerEndpoint(),
        )
    }
}
