@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property analyticalStorageTtl Analytical TTL.
 * @property etag A system generated property representing the resource etag required for optimistic concurrency control.
 * @property id Name of the Cosmos DB MongoDB collection
 * @property indexes List of index keys
 * @property rid A system generated property. A unique identifier.
 * @property shardKey A key-value pair of shard keys to be applied for the request.
 * @property ts A system generated property that denotes the last updated timestamp of the resource.
 */
public data class MongoDBCollectionGetPropertiesResponseResource(
    public val analyticalStorageTtl: Int? = null,
    public val etag: String,
    public val id: String,
    public val indexes: List<MongoIndexResponse>? = null,
    public val rid: String,
    public val shardKey: Map<String, String>? = null,
    public val ts: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.MongoDBCollectionGetPropertiesResponseResource): MongoDBCollectionGetPropertiesResponseResource =
            MongoDBCollectionGetPropertiesResponseResource(
                analyticalStorageTtl = javaType.analyticalStorageTtl().map({ args0 -> args0 }).orElse(null),
                etag = javaType.etag(),
                id = javaType.id(),
                indexes = javaType.indexes().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.documentdb.kotlin.outputs.MongoIndexResponse.Companion.toKotlin(args0)
                    })
                }),
                rid = javaType.rid(),
                shardKey = javaType.shardKey().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                ts = javaType.ts(),
            )
    }
}
