@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property etag A system generated property representing the resource etag required for optimistic concurrency control.
 * @property id Name of the Cosmos DB MongoDB database
 * @property rid A system generated property. A unique identifier.
 * @property ts A system generated property that denotes the last updated timestamp of the resource.
 */
public data class MongoDBDatabaseGetPropertiesResponseResource(
    public val etag: String,
    public val id: String,
    public val rid: String,
    public val ts: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.MongoDBDatabaseGetPropertiesResponseResource): MongoDBDatabaseGetPropertiesResponseResource = MongoDBDatabaseGetPropertiesResponseResource(
            etag = javaType.etag(),
            id = javaType.id(),
            rid = javaType.rid(),
            ts = javaType.ts(),
        )
    }
}
