@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.Suppress

/**
 * Cosmos DB MongoDB collection index key
 * @property key Cosmos DB MongoDB collection index keys
 * @property options Cosmos DB MongoDB collection index key options
 */
public data class MongoIndexResponse(
    public val key: MongoIndexKeysResponse? = null,
    public val options: MongoIndexOptionsResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.MongoIndexResponse): MongoIndexResponse = MongoIndexResponse(
            key = javaType.key().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.MongoIndexKeysResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            options = javaType.options().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.MongoIndexOptionsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
