@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Specification for a node group.
 * @property diskSizeGB The disk storage size for the node group in GB. Example values: 128, 256, 512, 1024.
 * @property enableHa Whether high availability is enabled on the node group.
 * @property kind The node type deployed in the node group.
 * @property nodeCount The number of nodes in the node group.
 * @property sku The resource sku for the node group. This defines the size of CPU and memory that is provisioned for each node. Example values: 'M30', 'M40'.
 */
public data class NodeGroupSpecResponse(
    public val diskSizeGB: Double? = null,
    public val enableHa: Boolean? = null,
    public val kind: String? = null,
    public val nodeCount: Int? = null,
    public val sku: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.NodeGroupSpecResponse): NodeGroupSpecResponse = NodeGroupSpecResponse(
            diskSizeGB = javaType.diskSizeGB().map({ args0 -> args0 }).orElse(null),
            enableHa = javaType.enableHa().map({ args0 -> args0 }).orElse(null),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            nodeCount = javaType.nodeCount().map({ args0 -> args0 }).orElse(null),
            sku = javaType.sku().map({ args0 -> args0 }).orElse(null),
        )
    }
}
