@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Connection State of the Private Endpoint Connection.
 * @property actionsRequired Any action that is required beyond basic workflow (approve/ reject/ disconnect)
 * @property description The private link service connection description.
 * @property status The private link service connection status.
 */
public data class PrivateLinkServiceConnectionStatePropertyResponse(
    public val actionsRequired: String,
    public val description: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.PrivateLinkServiceConnectionStatePropertyResponse): PrivateLinkServiceConnectionStatePropertyResponse =
            PrivateLinkServiceConnectionStatePropertyResponse(
                actionsRequired = javaType.actionsRequired(),
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                status = javaType.status().map({ args0 -> args0 }).orElse(null),
            )
    }
}
