@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An Azure Cosmos DB Mongo DB Resource.
 * @property collection The collection name the role is applied.
 * @property db The database name the role is applied.
 */
public data class PrivilegeResponseResource(
    public val collection: String? = null,
    public val db: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.PrivilegeResponseResource): PrivilegeResponseResource = PrivilegeResponseResource(
            collection = javaType.collection().map({ args0 -> args0 }).orElse(null),
            db = javaType.db().map({ args0 -> args0 }).orElse(null),
        )
    }
}
