@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The set of roles permitted through this Role Definition.
 * @property db The database name the role is applied.
 * @property role The role name.
 */
public data class RoleResponse(
    public val db: String? = null,
    public val role: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.RoleResponse): RoleResponse = RoleResponse(
            db = javaType.db().map({ args0 -> args0 }).orElse(null),
            role = javaType.role().map({ args0 -> args0 }).orElse(null),
        )
    }
}
