@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Resource for a regional service location.
 * @property location The location name.
 * @property name The regional service name.
 * @property sqlDedicatedGatewayEndpoint The regional endpoint for SqlDedicatedGateway.
 * @property status Describes the status of a service.
 */
public data class SqlDedicatedGatewayRegionalServiceResourceResponse(
    public val location: String,
    public val name: String,
    public val sqlDedicatedGatewayEndpoint: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.SqlDedicatedGatewayRegionalServiceResourceResponse): SqlDedicatedGatewayRegionalServiceResourceResponse =
            SqlDedicatedGatewayRegionalServiceResourceResponse(
                location = javaType.location(),
                name = javaType.name(),
                sqlDedicatedGatewayEndpoint = javaType.sqlDedicatedGatewayEndpoint(),
                status = javaType.status(),
            )
    }
}
