@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property body Body of the Trigger
 * @property etag A system generated property representing the resource etag required for optimistic concurrency control.
 * @property id Name of the Cosmos DB SQL trigger
 * @property rid A system generated property. A unique identifier.
 * @property triggerOperation The operation the trigger is associated with
 * @property triggerType Type of the Trigger
 * @property ts A system generated property that denotes the last updated timestamp of the resource.
 */
public data class SqlTriggerGetPropertiesResponseResource(
    public val body: String? = null,
    public val etag: String,
    public val id: String,
    public val rid: String,
    public val triggerOperation: String? = null,
    public val triggerType: String? = null,
    public val ts: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.SqlTriggerGetPropertiesResponseResource): SqlTriggerGetPropertiesResponseResource = SqlTriggerGetPropertiesResponseResource(
            body = javaType.body().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id(),
            rid = javaType.rid(),
            triggerOperation = javaType.triggerOperation().map({ args0 -> args0 }).orElse(null),
            triggerType = javaType.triggerType().map({ args0 -> args0 }).orElse(null),
            ts = javaType.ts(),
        )
    }
}
