@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos DB service.
 * @property uniqueKeys List of unique keys on that enforces uniqueness constraint on documents in the collection in the Azure Cosmos DB service.
 */
public data class UniqueKeyPolicyResponse(
    public val uniqueKeys: List<UniqueKeyResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.UniqueKeyPolicyResponse): UniqueKeyPolicyResponse = UniqueKeyPolicyResponse(
            uniqueKeys = javaType.uniqueKeys().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.UniqueKeyResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
