@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The unique key on that enforces uniqueness constraint on documents in the collection in the Azure Cosmos DB service.
 * @property paths List of paths must be unique for each document in the Azure Cosmos DB service
 */
public data class UniqueKeyResponse(
    public val paths: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.UniqueKeyResponse): UniqueKeyResponse = UniqueKeyResponse(
            paths = javaType.paths().map({ args0 -> args0 }),
        )
    }
}
