@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.domainregistration.kotlin.inputs

import com.pulumi.azurenative.domainregistration.inputs.ContactArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Contact information for domain registration. If 'Domain Privacy' option is not selected then the contact information is made publicly available through the Whois
 * directories as per ICANN requirements.
 * @property addressMailing Mailing address.
 * @property email Email address.
 * @property fax Fax number.
 * @property jobTitle Job title.
 * @property nameFirst First name.
 * @property nameLast Last name.
 * @property nameMiddle Middle name.
 * @property organization Organization contact belongs to.
 * @property phone Phone number.
 */
public data class ContactArgs(
    public val addressMailing: Output<AddressArgs>? = null,
    public val email: Output<String>,
    public val fax: Output<String>? = null,
    public val jobTitle: Output<String>? = null,
    public val nameFirst: Output<String>,
    public val nameLast: Output<String>,
    public val nameMiddle: Output<String>? = null,
    public val organization: Output<String>? = null,
    public val phone: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.domainregistration.inputs.ContactArgs> {
    override fun toJava(): com.pulumi.azurenative.domainregistration.inputs.ContactArgs =
        com.pulumi.azurenative.domainregistration.inputs.ContactArgs.builder()
            .addressMailing(addressMailing?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .email(email.applyValue({ args0 -> args0 }))
            .fax(fax?.applyValue({ args0 -> args0 }))
            .jobTitle(jobTitle?.applyValue({ args0 -> args0 }))
            .nameFirst(nameFirst.applyValue({ args0 -> args0 }))
            .nameLast(nameLast.applyValue({ args0 -> args0 }))
            .nameMiddle(nameMiddle?.applyValue({ args0 -> args0 }))
            .organization(organization?.applyValue({ args0 -> args0 }))
            .phone(phone.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContactArgs].
 */
@PulumiTagMarker
public class ContactArgsBuilder internal constructor() {
    private var addressMailing: Output<AddressArgs>? = null

    private var email: Output<String>? = null

    private var fax: Output<String>? = null

    private var jobTitle: Output<String>? = null

    private var nameFirst: Output<String>? = null

    private var nameLast: Output<String>? = null

    private var nameMiddle: Output<String>? = null

    private var organization: Output<String>? = null

    private var phone: Output<String>? = null

    /**
     * @param value Mailing address.
     */
    @JvmName("shhvuxckutnonvrl")
    public suspend fun addressMailing(`value`: Output<AddressArgs>) {
        this.addressMailing = value
    }

    /**
     * @param value Email address.
     */
    @JvmName("jvqlhcgotullnfhw")
    public suspend fun email(`value`: Output<String>) {
        this.email = value
    }

    /**
     * @param value Fax number.
     */
    @JvmName("peaolexhiuqaooha")
    public suspend fun fax(`value`: Output<String>) {
        this.fax = value
    }

    /**
     * @param value Job title.
     */
    @JvmName("tgaqombwcglandql")
    public suspend fun jobTitle(`value`: Output<String>) {
        this.jobTitle = value
    }

    /**
     * @param value First name.
     */
    @JvmName("tgitqdppwgtqbjlg")
    public suspend fun nameFirst(`value`: Output<String>) {
        this.nameFirst = value
    }

    /**
     * @param value Last name.
     */
    @JvmName("itypfrbdkvlqrexy")
    public suspend fun nameLast(`value`: Output<String>) {
        this.nameLast = value
    }

    /**
     * @param value Middle name.
     */
    @JvmName("rvbprvbapbrtcdiw")
    public suspend fun nameMiddle(`value`: Output<String>) {
        this.nameMiddle = value
    }

    /**
     * @param value Organization contact belongs to.
     */
    @JvmName("yggjbtnptempqaca")
    public suspend fun organization(`value`: Output<String>) {
        this.organization = value
    }

    /**
     * @param value Phone number.
     */
    @JvmName("bgjinvwxhluwdita")
    public suspend fun phone(`value`: Output<String>) {
        this.phone = value
    }

    /**
     * @param value Mailing address.
     */
    @JvmName("yaqhtmnumxorvyjc")
    public suspend fun addressMailing(`value`: AddressArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressMailing = mapped
    }

    /**
     * @param argument Mailing address.
     */
    @JvmName("nvgfycdvbeswplgk")
    public suspend fun addressMailing(argument: suspend AddressArgsBuilder.() -> Unit) {
        val toBeMapped = AddressArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.addressMailing = mapped
    }

    /**
     * @param value Email address.
     */
    @JvmName("wbbufxxlsmyxkier")
    public suspend fun email(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.email = mapped
    }

    /**
     * @param value Fax number.
     */
    @JvmName("ghvxknlgjprmkaot")
    public suspend fun fax(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fax = mapped
    }

    /**
     * @param value Job title.
     */
    @JvmName("lujkdiilobcfhkce")
    public suspend fun jobTitle(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobTitle = mapped
    }

    /**
     * @param value First name.
     */
    @JvmName("rppesxksopfwcvsv")
    public suspend fun nameFirst(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nameFirst = mapped
    }

    /**
     * @param value Last name.
     */
    @JvmName("wspjyhwufbjjiroj")
    public suspend fun nameLast(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nameLast = mapped
    }

    /**
     * @param value Middle name.
     */
    @JvmName("lubyyldqgsskdijx")
    public suspend fun nameMiddle(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nameMiddle = mapped
    }

    /**
     * @param value Organization contact belongs to.
     */
    @JvmName("ucyiojvifwwfybct")
    public suspend fun organization(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.organization = mapped
    }

    /**
     * @param value Phone number.
     */
    @JvmName("dtatrjtndxtfqpbl")
    public suspend fun phone(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.phone = mapped
    }

    internal fun build(): ContactArgs = ContactArgs(
        addressMailing = addressMailing,
        email = email ?: throw PulumiNullFieldException("email"),
        fax = fax,
        jobTitle = jobTitle,
        nameFirst = nameFirst ?: throw PulumiNullFieldException("nameFirst"),
        nameLast = nameLast ?: throw PulumiNullFieldException("nameLast"),
        nameMiddle = nameMiddle,
        organization = organization,
        phone = phone ?: throw PulumiNullFieldException("phone"),
    )
}
