@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.domainregistration.kotlin.inputs

import com.pulumi.azurenative.domainregistration.inputs.DomainPurchaseConsentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Domain purchase consent object, representing acceptance of applicable legal agreements.
 * @property agreedAt Timestamp when the agreements were accepted.
 * @property agreedBy Client IP address.
 * @property agreementKeys List of applicable legal agreement keys. This list can be retrieved using ListLegalAgreements API under <code>TopLevelDomain</code> resource.
 */
public data class DomainPurchaseConsentArgs(
    public val agreedAt: Output<String>? = null,
    public val agreedBy: Output<String>? = null,
    public val agreementKeys: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.domainregistration.inputs.DomainPurchaseConsentArgs> {
    override fun toJava(): com.pulumi.azurenative.domainregistration.inputs.DomainPurchaseConsentArgs = com.pulumi.azurenative.domainregistration.inputs.DomainPurchaseConsentArgs.builder()
        .agreedAt(agreedAt?.applyValue({ args0 -> args0 }))
        .agreedBy(agreedBy?.applyValue({ args0 -> args0 }))
        .agreementKeys(agreementKeys?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DomainPurchaseConsentArgs].
 */
@PulumiTagMarker
public class DomainPurchaseConsentArgsBuilder internal constructor() {
    private var agreedAt: Output<String>? = null

    private var agreedBy: Output<String>? = null

    private var agreementKeys: Output<List<String>>? = null

    /**
     * @param value Timestamp when the agreements were accepted.
     */
    @JvmName("ksvuposveomvyvos")
    public suspend fun agreedAt(`value`: Output<String>) {
        this.agreedAt = value
    }

    /**
     * @param value Client IP address.
     */
    @JvmName("vfuidgscnqtdrsji")
    public suspend fun agreedBy(`value`: Output<String>) {
        this.agreedBy = value
    }

    /**
     * @param value List of applicable legal agreement keys. This list can be retrieved using ListLegalAgreements API under <code>TopLevelDomain</code> resource.
     */
    @JvmName("ntbaglmaijgsihxs")
    public suspend fun agreementKeys(`value`: Output<List<String>>) {
        this.agreementKeys = value
    }

    @JvmName("phlblxfknoqihepc")
    public suspend fun agreementKeys(vararg values: Output<String>) {
        this.agreementKeys = Output.all(values.asList())
    }

    /**
     * @param values List of applicable legal agreement keys. This list can be retrieved using ListLegalAgreements API under <code>TopLevelDomain</code> resource.
     */
    @JvmName("icptosrhgxpcgeby")
    public suspend fun agreementKeys(values: List<Output<String>>) {
        this.agreementKeys = Output.all(values)
    }

    /**
     * @param value Timestamp when the agreements were accepted.
     */
    @JvmName("nfbcmoucwxniedom")
    public suspend fun agreedAt(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agreedAt = mapped
    }

    /**
     * @param value Client IP address.
     */
    @JvmName("euwtuegfuucxibuu")
    public suspend fun agreedBy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agreedBy = mapped
    }

    /**
     * @param value List of applicable legal agreement keys. This list can be retrieved using ListLegalAgreements API under <code>TopLevelDomain</code> resource.
     */
    @JvmName("vjuyortfawaslxip")
    public suspend fun agreementKeys(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agreementKeys = mapped
    }

    /**
     * @param values List of applicable legal agreement keys. This list can be retrieved using ListLegalAgreements API under <code>TopLevelDomain</code> resource.
     */
    @JvmName("dsewltidwkikrgfd")
    public suspend fun agreementKeys(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.agreementKeys = mapped
    }

    internal fun build(): DomainPurchaseConsentArgs = DomainPurchaseConsentArgs(
        agreedAt = agreedAt,
        agreedBy = agreedBy,
        agreementKeys = agreementKeys,
    )
}
