@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.domainregistration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Domain ownership Identifier.
 * @property id Resource Id.
 * @property kind Kind of resource.
 * @property name Resource Name.
 * @property ownershipId Ownership Id.
 * @property type Resource type.
 */
public data class GetDomainOwnershipIdentifierResult(
    public val id: String,
    public val kind: String? = null,
    public val name: String,
    public val ownershipId: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.domainregistration.outputs.GetDomainOwnershipIdentifierResult): GetDomainOwnershipIdentifierResult = GetDomainOwnershipIdentifierResult(
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            ownershipId = javaType.ownershipId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
