@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.domainregistration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Details of a hostname derived from a domain.
 * @property azureResourceName Name of the Azure resource the hostname is assigned to. If it is assigned to a Traffic Manager then it will be the Traffic Manager name otherwise it will be the app name.
 * @property azureResourceType Type of the Azure resource the hostname is assigned to.
 * @property customHostNameDnsRecordType Type of the DNS record.
 * @property hostNameType Type of the hostname.
 * @property name Name of the hostname.
 * @property siteNames List of apps the hostname is assigned to. This list will have more than one app only if the hostname is pointing to a Traffic Manager.
 */
public data class HostNameResponse(
    public val azureResourceName: String? = null,
    public val azureResourceType: String? = null,
    public val customHostNameDnsRecordType: String? = null,
    public val hostNameType: String? = null,
    public val name: String? = null,
    public val siteNames: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.domainregistration.outputs.HostNameResponse): HostNameResponse = HostNameResponse(
            azureResourceName = javaType.azureResourceName().map({ args0 -> args0 }).orElse(null),
            azureResourceType = javaType.azureResourceType().map({ args0 -> args0 }).orElse(null),
            customHostNameDnsRecordType = javaType.customHostNameDnsRecordType().map({ args0 ->
                args0
            }).orElse(null),
            hostNameType = javaType.hostNameType().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            siteNames = javaType.siteNames().map({ args0 -> args0 }),
        )
    }
}
