@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.domainregistration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Legal agreement for a top level domain.
 * @property agreementKey Unique identifier for the agreement.
 * @property content Agreement details.
 * @property title Agreement title.
 * @property url URL where a copy of the agreement details is hosted.
 */
public data class TldLegalAgreementResponse(
    public val agreementKey: String,
    public val content: String,
    public val title: String,
    public val url: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.domainregistration.outputs.TldLegalAgreementResponse): TldLegalAgreementResponse = TldLegalAgreementResponse(
            agreementKey = javaType.agreementKey(),
            content = javaType.content(),
            title = javaType.title(),
            url = javaType.url().map({ args0 -> args0 }).orElse(null),
        )
    }
}
