@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dynamics365fraudprotection.kotlin

import com.pulumi.azurenative.dynamics365fraudprotection.Dynamics365fraudprotectionFunctions.getInstanceDetailsPlain
import com.pulumi.azurenative.dynamics365fraudprotection.kotlin.inputs.GetInstanceDetailsPlainArgs
import com.pulumi.azurenative.dynamics365fraudprotection.kotlin.inputs.GetInstanceDetailsPlainArgsBuilder
import com.pulumi.azurenative.dynamics365fraudprotection.kotlin.outputs.GetInstanceDetailsResult
import com.pulumi.azurenative.dynamics365fraudprotection.kotlin.outputs.GetInstanceDetailsResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object Dynamics365fraudprotectionFunctions {
    /**
     * Gets details about the specified instances.
     * Azure REST API version: 2021-02-01-preview.
     * @param argument null
     * @return Represents an instance of a DFP instance resource.
     */
    public suspend fun getInstanceDetails(argument: GetInstanceDetailsPlainArgs): GetInstanceDetailsResult = toKotlin(getInstanceDetailsPlain(argument.toJava()).await())

    /**
     * @see [getInstanceDetails].
     * @param instanceName The name of the instance. It must be a minimum of 3 characters, and a maximum of 63.
     * @param resourceGroupName The name of the Azure Resource group of which a given DFP instance is part. This name must be at least 1 character in length, and no more than 90.
     * @return Represents an instance of a DFP instance resource.
     */
    public suspend fun getInstanceDetails(instanceName: String, resourceGroupName: String): GetInstanceDetailsResult {
        val argument = GetInstanceDetailsPlainArgs(
            instanceName = instanceName,
            resourceGroupName = resourceGroupName,
        )
        return toKotlin(getInstanceDetailsPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstanceDetails].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;dynamics365fraudprotection&#46;kotlin&#46;inputs&#46;GetInstanceDetailsPlainArgs].
     * @return Represents an instance of a DFP instance resource.
     */
    public suspend fun getInstanceDetails(argument: suspend GetInstanceDetailsPlainArgsBuilder.() -> Unit): GetInstanceDetailsResult {
        val builder = GetInstanceDetailsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getInstanceDetailsPlain(builtArgument.toJava()).await())
    }
}
