@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dynamics365fraudprotection.kotlin

import com.pulumi.azurenative.dynamics365fraudprotection.kotlin.outputs.DFPInstanceAdministratorsResponse
import com.pulumi.azurenative.dynamics365fraudprotection.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.dynamics365fraudprotection.kotlin.outputs.DFPInstanceAdministratorsResponse.Companion.toKotlin as dFPInstanceAdministratorsResponseToKotlin
import com.pulumi.azurenative.dynamics365fraudprotection.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [InstanceDetails].
 */
@PulumiTagMarker
public class InstanceDetailsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceDetailsArgs = InstanceDetailsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceDetailsArgsBuilder.() -> Unit) {
        val builder = InstanceDetailsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): InstanceDetails {
        val builtJavaResource =
            com.pulumi.azurenative.dynamics365fraudprotection.InstanceDetails(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return InstanceDetails(builtJavaResource)
    }
}

/**
 * Represents an instance of a DFP instance resource.
 * Azure REST API version: 2021-02-01-preview. Prior API version in Azure Native 1.x: 2021-02-01-preview.
 * ## Example Usage
 * ### Create instance
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var instanceDetails = new AzureNative.Dynamics365Fraudprotection.InstanceDetails("instanceDetails", new()
 *     {
 *         Administration = new AzureNative.Dynamics365Fraudprotection.Inputs.DFPInstanceAdministratorsArgs
 *         {
 *             Members = new[]
 *             {
 *                 "azsdktest@microsoft.com",
 *                 "azsdktest2@microsoft.com",
 *             },
 *         },
 *         InstanceName = "azsdktest",
 *         Location = "West US",
 *         ResourceGroupName = "TestRG",
 *         Tags =
 *         {
 *             { "testKey", "testValue" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dynamics365fraudprotection/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dynamics365fraudprotection.NewInstanceDetails(ctx, "instanceDetails", &dynamics365fraudprotection.InstanceDetailsArgs{
 * 			Administration: &dynamics365fraudprotection.DFPInstanceAdministratorsArgs{
 * 				Members: pulumi.StringArray{
 * 					pulumi.String("azsdktest@microsoft.com"),
 * 					pulumi.String("azsdktest2@microsoft.com"),
 * 				},
 * 			},
 * 			InstanceName:      pulumi.String("azsdktest"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("TestRG"),
 * 			Tags: pulumi.StringMap{
 * 				"testKey": pulumi.String("testValue"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dynamics365fraudprotection.InstanceDetails;
 * import com.pulumi.azurenative.dynamics365fraudprotection.InstanceDetailsArgs;
 * import com.pulumi.azurenative.dynamics365fraudprotection.inputs.DFPInstanceAdministratorsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var instanceDetails = new InstanceDetails("instanceDetails", InstanceDetailsArgs.builder()
 *             .administration(DFPInstanceAdministratorsArgs.builder()
 *                 .members(
 *                     "azsdktest@microsoft.com",
 *                     "azsdktest2@microsoft.com")
 *                 .build())
 *             .instanceName("azsdktest")
 *             .location("West US")
 *             .resourceGroupName("TestRG")
 *             .tags(Map.of("testKey", "testValue"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:dynamics365fraudprotection:InstanceDetails azsdktest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dynamics365FraudProtection/instances/{instanceName}
 * ```
 */
public class InstanceDetails internal constructor(
    override val javaResource: com.pulumi.azurenative.dynamics365fraudprotection.InstanceDetails,
) : KotlinCustomResource(javaResource, InstanceDetailsMapper) {
    /**
     * A collection of DFP instance administrators
     */
    public val administration: Output<DFPInstanceAdministratorsResponse>?
        get() = javaResource.administration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> dFPInstanceAdministratorsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Location of the DFP resource.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The current deployment state of DFP resource. The provisioningState is to indicate states for resource provisioning.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Key-value pairs of additional resource provisioning properties.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object InstanceDetailsMapper : ResourceMapper<InstanceDetails> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.dynamics365fraudprotection.InstanceDetails::class == javaResource::class

    override fun map(javaResource: Resource): InstanceDetails = InstanceDetails(
        javaResource as
            com.pulumi.azurenative.dynamics365fraudprotection.InstanceDetails,
    )
}

/**
 * @see [InstanceDetails].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [InstanceDetails].
 */
public suspend fun instanceDetails(
    name: String,
    block: suspend InstanceDetailsResourceBuilder.() -> Unit,
): InstanceDetails {
    val builder = InstanceDetailsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [InstanceDetails].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instanceDetails(name: String): InstanceDetails {
    val builder = InstanceDetailsResourceBuilder()
    builder.name(name)
    return builder.build()
}
