@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.easm.kotlin.inputs

import com.pulumi.azurenative.easm.inputs.GetLabelByWorkspacePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property labelName The name of the Label.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName The name of the Workspace.
 */
public data class GetLabelByWorkspacePlainArgs(
    public val labelName: String,
    public val resourceGroupName: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.easm.inputs.GetLabelByWorkspacePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.easm.inputs.GetLabelByWorkspacePlainArgs =
        com.pulumi.azurenative.easm.inputs.GetLabelByWorkspacePlainArgs.builder()
            .labelName(labelName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLabelByWorkspacePlainArgs].
 */
@PulumiTagMarker
public class GetLabelByWorkspacePlainArgsBuilder internal constructor() {
    private var labelName: String? = null

    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the Label.
     */
    @JvmName("rapcrjmsocmeqktb")
    public suspend fun labelName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.labelName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("endjehnishngewry")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Workspace.
     */
    @JvmName("jqiqkbomeskvhbwr")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetLabelByWorkspacePlainArgs = GetLabelByWorkspacePlainArgs(
        labelName = labelName ?: throw PulumiNullFieldException("labelName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
