@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.easm.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Label details
 * @property color Label color.
 * @property displayName Label display name.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property provisioningState Resource provisioning state.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetLabelByWorkspaceResult(
    public val color: String? = null,
    public val displayName: String? = null,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.easm.outputs.GetLabelByWorkspaceResult): GetLabelByWorkspaceResult = GetLabelByWorkspaceResult(
            color = javaType.color().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.easm.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
