@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgemarketplace.kotlin

import com.pulumi.azurenative.edgemarketplace.EdgemarketplaceFunctions.getOfferAccessTokenPlain
import com.pulumi.azurenative.edgemarketplace.kotlin.inputs.GetOfferAccessTokenPlainArgs
import com.pulumi.azurenative.edgemarketplace.kotlin.inputs.GetOfferAccessTokenPlainArgsBuilder
import com.pulumi.azurenative.edgemarketplace.kotlin.outputs.GetOfferAccessTokenResult
import com.pulumi.azurenative.edgemarketplace.kotlin.outputs.GetOfferAccessTokenResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object EdgemarketplaceFunctions {
    /**
     * get access token.
     * Azure REST API version: 2023-08-01-preview.
     * Other available API versions: 2023-08-01.
     * @param argument null
     * @return The disk access token
     */
    public suspend fun getOfferAccessToken(argument: GetOfferAccessTokenPlainArgs): GetOfferAccessTokenResult = toKotlin(getOfferAccessTokenPlain(argument.toJava()).await())

    /**
     * @see [getOfferAccessToken].
     * @param offerId Id of the offer
     * @param requestId The name of the publisher.
     * @param resourceUri The fully qualified Azure Resource manager identifier of the resource.
     * @return The disk access token
     */
    public suspend fun getOfferAccessToken(
        offerId: String,
        requestId: String,
        resourceUri: String,
    ): GetOfferAccessTokenResult {
        val argument = GetOfferAccessTokenPlainArgs(
            offerId = offerId,
            requestId = requestId,
            resourceUri = resourceUri,
        )
        return toKotlin(getOfferAccessTokenPlain(argument.toJava()).await())
    }

    /**
     * @see [getOfferAccessToken].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;edgemarketplace&#46;kotlin&#46;inputs&#46;GetOfferAccessTokenPlainArgs].
     * @return The disk access token
     */
    public suspend fun getOfferAccessToken(argument: suspend GetOfferAccessTokenPlainArgsBuilder.() -> Unit): GetOfferAccessTokenResult {
        val builder = GetOfferAccessTokenPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getOfferAccessTokenPlain(builtArgument.toJava()).await())
    }
}
