@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgemarketplace.kotlin.inputs

import com.pulumi.azurenative.edgemarketplace.inputs.GetOfferAccessTokenPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property offerId Id of the offer
 * @property requestId The name of the publisher.
 * @property resourceUri The fully qualified Azure Resource manager identifier of the resource.
 */
public data class GetOfferAccessTokenPlainArgs(
    public val offerId: String,
    public val requestId: String,
    public val resourceUri: String,
) : ConvertibleToJava<com.pulumi.azurenative.edgemarketplace.inputs.GetOfferAccessTokenPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.edgemarketplace.inputs.GetOfferAccessTokenPlainArgs = com.pulumi.azurenative.edgemarketplace.inputs.GetOfferAccessTokenPlainArgs.builder()
        .offerId(offerId.let({ args0 -> args0 }))
        .requestId(requestId.let({ args0 -> args0 }))
        .resourceUri(resourceUri.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetOfferAccessTokenPlainArgs].
 */
@PulumiTagMarker
public class GetOfferAccessTokenPlainArgsBuilder internal constructor() {
    private var offerId: String? = null

    private var requestId: String? = null

    private var resourceUri: String? = null

    /**
     * @param value Id of the offer
     */
    @JvmName("judnwgbkgwapltgf")
    public suspend fun offerId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.offerId = mapped
    }

    /**
     * @param value The name of the publisher.
     */
    @JvmName("uokdacabndobnbiy")
    public suspend fun requestId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.requestId = mapped
    }

    /**
     * @param value The fully qualified Azure Resource manager identifier of the resource.
     */
    @JvmName("nsarglbfmgqkyssv")
    public suspend fun resourceUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceUri = mapped
    }

    internal fun build(): GetOfferAccessTokenPlainArgs = GetOfferAccessTokenPlainArgs(
        offerId = offerId ?: throw PulumiNullFieldException("offerId"),
        requestId = requestId ?: throw PulumiNullFieldException("requestId"),
        resourceUri = resourceUri ?: throw PulumiNullFieldException("resourceUri"),
    )
}
