@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgemarketplace.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The disk access token
 * @property accessToken The access token.
 * @property diskId The disk id.
 * @property status The access token creation status.
 */
public data class GetOfferAccessTokenResult(
    public val accessToken: String,
    public val diskId: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.edgemarketplace.outputs.GetOfferAccessTokenResult): GetOfferAccessTokenResult = GetOfferAccessTokenResult(
            accessToken = javaType.accessToken(),
            diskId = javaType.diskId().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
