@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin

import com.pulumi.azurenative.edgeorder.kotlin.outputs.ContactDetailsResponse
import com.pulumi.azurenative.edgeorder.kotlin.outputs.ShippingAddressResponse
import com.pulumi.azurenative.edgeorder.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.edgeorder.kotlin.outputs.ContactDetailsResponse.Companion.toKotlin as contactDetailsResponseToKotlin
import com.pulumi.azurenative.edgeorder.kotlin.outputs.ShippingAddressResponse.Companion.toKotlin as shippingAddressResponseToKotlin
import com.pulumi.azurenative.edgeorder.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Address].
 */
@PulumiTagMarker
public class AddressResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AddressArgs = AddressArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AddressArgsBuilder.() -> Unit) {
        val builder = AddressArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Address {
        val builtJavaResource = com.pulumi.azurenative.edgeorder.Address(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Address(builtJavaResource)
    }
}

/**
 * Address Resource.
 * Azure REST API version: 2022-05-01-preview.
 * Other available API versions: 2024-02-01.
 * ## Example Usage
 * ### CreateAddress
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var address = new AzureNative.EdgeOrder.Address("address", new()
 *     {
 *         AddressName = "TestAddressName2",
 *         ContactDetails = new AzureNative.EdgeOrder.Inputs.ContactDetailsArgs
 *         {
 *             ContactName = "XXXX XXXX",
 *             EmailList = new[]
 *             {
 *                 "xxxx@xxxx.xxx",
 *             },
 *             Phone = "0000000000",
 *             PhoneExtension = "",
 *         },
 *         Location = "eastus",
 *         ResourceGroupName = "YourResourceGroupName",
 *         ShippingAddress = new AzureNative.EdgeOrder.Inputs.ShippingAddressArgs
 *         {
 *             AddressType = AzureNative.EdgeOrder.AddressType.None,
 *             City = "San Francisco",
 *             CompanyName = "Microsoft",
 *             Country = "US",
 *             PostalCode = "94107",
 *             StateOrProvince = "CA",
 *             StreetAddress1 = "16 TOWNSEND ST",
 *             StreetAddress2 = "UNIT 1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/edgeorder/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := edgeorder.NewAddress(ctx, "address", &edgeorder.AddressArgs{
 * 			AddressName: pulumi.String("TestAddressName2"),
 * 			ContactDetails: &edgeorder.ContactDetailsArgs{
 * 				ContactName: pulumi.String("XXXX XXXX"),
 * 				EmailList: pulumi.StringArray{
 * 					pulumi.String("xxxx@xxxx.xxx"),
 * 				},
 * 				Phone:          pulumi.String("0000000000"),
 * 				PhoneExtension: pulumi.String(""),
 * 			},
 * 			Location:          pulumi.String("eastus"),
 * 			ResourceGroupName: pulumi.String("YourResourceGroupName"),
 * 			ShippingAddress: &edgeorder.ShippingAddressArgs{
 * 				AddressType:     pulumi.String(edgeorder.AddressTypeNone),
 * 				City:            pulumi.String("San Francisco"),
 * 				CompanyName:     pulumi.String("Microsoft"),
 * 				Country:         pulumi.String("US"),
 * 				PostalCode:      pulumi.String("94107"),
 * 				StateOrProvince: pulumi.String("CA"),
 * 				StreetAddress1:  pulumi.String("16 TOWNSEND ST"),
 * 				StreetAddress2:  pulumi.String("UNIT 1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.edgeorder.Address;
 * import com.pulumi.azurenative.edgeorder.AddressArgs;
 * import com.pulumi.azurenative.edgeorder.inputs.ContactDetailsArgs;
 * import com.pulumi.azurenative.edgeorder.inputs.ShippingAddressArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var address = new Address("address", AddressArgs.builder()
 *             .addressName("TestAddressName2")
 *             .contactDetails(ContactDetailsArgs.builder()
 *                 .contactName("XXXX XXXX")
 *                 .emailList("xxxx@xxxx.xxx")
 *                 .phone("0000000000")
 *                 .phoneExtension("")
 *                 .build())
 *             .location("eastus")
 *             .resourceGroupName("YourResourceGroupName")
 *             .shippingAddress(ShippingAddressArgs.builder()
 *                 .addressType("None")
 *                 .city("San Francisco")
 *                 .companyName("Microsoft")
 *                 .country("US")
 *                 .postalCode("94107")
 *                 .stateOrProvince("CA")
 *                 .streetAddress1("16 TOWNSEND ST")
 *                 .streetAddress2("UNIT 1")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:edgeorder:Address TestAddressName2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/addresses/{addressName}
 * ```
 */
public class Address internal constructor(
    override val javaResource: com.pulumi.azurenative.edgeorder.Address,
) : KotlinCustomResource(javaResource, AddressMapper) {
    /**
     * Status of address validation.
     */
    public val addressValidationStatus: Output<String>
        get() = javaResource.addressValidationStatus().applyValue({ args0 -> args0 })

    /**
     * Contact details for the address.
     */
    public val contactDetails: Output<ContactDetailsResponse>
        get() = javaResource.contactDetails().applyValue({ args0 ->
            args0.let({ args0 ->
                contactDetailsResponseToKotlin(args0)
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Shipping details for the address.
     */
    public val shippingAddress: Output<ShippingAddressResponse>?
        get() = javaResource.shippingAddress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> shippingAddressResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Represents resource creation and update time.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AddressMapper : ResourceMapper<Address> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.edgeorder.Address::class == javaResource::class

    override fun map(javaResource: Resource): Address = Address(
        javaResource as
            com.pulumi.azurenative.edgeorder.Address,
    )
}

/**
 * @see [Address].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Address].
 */
public suspend fun address(name: String, block: suspend AddressResourceBuilder.() -> Unit): Address {
    val builder = AddressResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Address].
 * @param name The _unique_ name of the resulting resource.
 */
public fun address(name: String): Address {
    val builder = AddressResourceBuilder()
    builder.name(name)
    return builder.build()
}
