@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin

import com.pulumi.azurenative.edgeorder.EdgeorderFunctions.getAddressByNamePlain
import com.pulumi.azurenative.edgeorder.EdgeorderFunctions.getAddressPlain
import com.pulumi.azurenative.edgeorder.EdgeorderFunctions.getOrderItemByNamePlain
import com.pulumi.azurenative.edgeorder.EdgeorderFunctions.getOrderItemPlain
import com.pulumi.azurenative.edgeorder.EdgeorderFunctions.listConfigurationsPlain
import com.pulumi.azurenative.edgeorder.EdgeorderFunctions.listProductFamiliesPlain
import com.pulumi.azurenative.edgeorder.EdgeorderFunctions.listProductsAndConfigurationProductFamiliesPlain
import com.pulumi.azurenative.edgeorder.EdgeorderFunctions.listProductsAndConfigurationsPlain
import com.pulumi.azurenative.edgeorder.kotlin.inputs.ConfigurationFilter
import com.pulumi.azurenative.edgeorder.kotlin.inputs.ConfigurationFilters
import com.pulumi.azurenative.edgeorder.kotlin.inputs.CustomerSubscriptionDetails
import com.pulumi.azurenative.edgeorder.kotlin.inputs.FilterableProperty
import com.pulumi.azurenative.edgeorder.kotlin.inputs.GetAddressByNamePlainArgs
import com.pulumi.azurenative.edgeorder.kotlin.inputs.GetAddressByNamePlainArgsBuilder
import com.pulumi.azurenative.edgeorder.kotlin.inputs.GetAddressPlainArgs
import com.pulumi.azurenative.edgeorder.kotlin.inputs.GetAddressPlainArgsBuilder
import com.pulumi.azurenative.edgeorder.kotlin.inputs.GetOrderItemByNamePlainArgs
import com.pulumi.azurenative.edgeorder.kotlin.inputs.GetOrderItemByNamePlainArgsBuilder
import com.pulumi.azurenative.edgeorder.kotlin.inputs.GetOrderItemPlainArgs
import com.pulumi.azurenative.edgeorder.kotlin.inputs.GetOrderItemPlainArgsBuilder
import com.pulumi.azurenative.edgeorder.kotlin.inputs.ListConfigurationsPlainArgs
import com.pulumi.azurenative.edgeorder.kotlin.inputs.ListConfigurationsPlainArgsBuilder
import com.pulumi.azurenative.edgeorder.kotlin.inputs.ListProductFamiliesPlainArgs
import com.pulumi.azurenative.edgeorder.kotlin.inputs.ListProductFamiliesPlainArgsBuilder
import com.pulumi.azurenative.edgeorder.kotlin.inputs.ListProductsAndConfigurationProductFamiliesPlainArgs
import com.pulumi.azurenative.edgeorder.kotlin.inputs.ListProductsAndConfigurationProductFamiliesPlainArgsBuilder
import com.pulumi.azurenative.edgeorder.kotlin.inputs.ListProductsAndConfigurationsPlainArgs
import com.pulumi.azurenative.edgeorder.kotlin.inputs.ListProductsAndConfigurationsPlainArgsBuilder
import com.pulumi.azurenative.edgeorder.kotlin.outputs.GetAddressByNameResult
import com.pulumi.azurenative.edgeorder.kotlin.outputs.GetAddressResult
import com.pulumi.azurenative.edgeorder.kotlin.outputs.GetOrderItemByNameResult
import com.pulumi.azurenative.edgeorder.kotlin.outputs.GetOrderItemResult
import com.pulumi.azurenative.edgeorder.kotlin.outputs.ListConfigurationsResult
import com.pulumi.azurenative.edgeorder.kotlin.outputs.ListProductFamiliesResult
import com.pulumi.azurenative.edgeorder.kotlin.outputs.ListProductsAndConfigurationProductFamiliesResult
import com.pulumi.azurenative.edgeorder.kotlin.outputs.ListProductsAndConfigurationsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.edgeorder.kotlin.outputs.GetAddressByNameResult.Companion.toKotlin as getAddressByNameResultToKotlin
import com.pulumi.azurenative.edgeorder.kotlin.outputs.GetAddressResult.Companion.toKotlin as getAddressResultToKotlin
import com.pulumi.azurenative.edgeorder.kotlin.outputs.GetOrderItemByNameResult.Companion.toKotlin as getOrderItemByNameResultToKotlin
import com.pulumi.azurenative.edgeorder.kotlin.outputs.GetOrderItemResult.Companion.toKotlin as getOrderItemResultToKotlin
import com.pulumi.azurenative.edgeorder.kotlin.outputs.ListConfigurationsResult.Companion.toKotlin as listConfigurationsResultToKotlin
import com.pulumi.azurenative.edgeorder.kotlin.outputs.ListProductFamiliesResult.Companion.toKotlin as listProductFamiliesResultToKotlin
import com.pulumi.azurenative.edgeorder.kotlin.outputs.ListProductsAndConfigurationProductFamiliesResult.Companion.toKotlin as listProductsAndConfigurationProductFamiliesResultToKotlin
import com.pulumi.azurenative.edgeorder.kotlin.outputs.ListProductsAndConfigurationsResult.Companion.toKotlin as listProductsAndConfigurationsResultToKotlin

public object EdgeorderFunctions {
    /**
     * Get information about the specified address.
     * Azure REST API version: 2022-05-01-preview.
     * Other available API versions: 2024-02-01.
     * @param argument null
     * @return Address Resource.
     */
    public suspend fun getAddress(argument: GetAddressPlainArgs): GetAddressResult =
        getAddressResultToKotlin(getAddressPlain(argument.toJava()).await())

    /**
     * @see [getAddress].
     * @param addressName The name of the address Resource within the specified resource group. address names must be between 3 and 24 characters in length and use any alphanumeric and underscore only.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Address Resource.
     */
    public suspend fun getAddress(addressName: String, resourceGroupName: String): GetAddressResult {
        val argument = GetAddressPlainArgs(
            addressName = addressName,
            resourceGroupName = resourceGroupName,
        )
        return getAddressResultToKotlin(getAddressPlain(argument.toJava()).await())
    }

    /**
     * @see [getAddress].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;edgeorder&#46;kotlin&#46;inputs&#46;GetAddressPlainArgs].
     * @return Address Resource.
     */
    public suspend fun getAddress(argument: suspend GetAddressPlainArgsBuilder.() -> Unit): GetAddressResult {
        val builder = GetAddressPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAddressResultToKotlin(getAddressPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about the specified address.
     * Azure REST API version: 2021-12-01.
     * @param argument null
     * @return Address Resource.
     */
    public suspend fun getAddressByName(argument: GetAddressByNamePlainArgs): GetAddressByNameResult =
        getAddressByNameResultToKotlin(getAddressByNamePlain(argument.toJava()).await())

    /**
     * @see [getAddressByName].
     * @param addressName The name of the address Resource within the specified resource group. address names must be between 3 and 24 characters in length and use any alphanumeric and underscore only
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Address Resource.
     */
    public suspend fun getAddressByName(addressName: String, resourceGroupName: String): GetAddressByNameResult {
        val argument = GetAddressByNamePlainArgs(
            addressName = addressName,
            resourceGroupName = resourceGroupName,
        )
        return getAddressByNameResultToKotlin(getAddressByNamePlain(argument.toJava()).await())
    }

    /**
     * @see [getAddressByName].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;edgeorder&#46;kotlin&#46;inputs&#46;GetAddressByNamePlainArgs].
     * @return Address Resource.
     */
    public suspend fun getAddressByName(argument: suspend GetAddressByNamePlainArgsBuilder.() -> Unit): GetAddressByNameResult {
        val builder = GetAddressByNamePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAddressByNameResultToKotlin(getAddressByNamePlain(builtArgument.toJava()).await())
    }

    /**
     * Get an order item.
     * Azure REST API version: 2022-05-01-preview.
     * Other available API versions: 2024-02-01.
     * @param argument null
     * @return Represents order item resource.
     */
    public suspend fun getOrderItem(argument: GetOrderItemPlainArgs): GetOrderItemResult =
        getOrderItemResultToKotlin(getOrderItemPlain(argument.toJava()).await())

    /**
     * @see [getOrderItem].
     * @param expand $expand is supported on parent device details, device details, forward shipping details and reverse shipping details parameters. Each of these can be provided as a comma separated list. Parent Device Details for order item provides details on the devices of the product, Device Details for order item provides details on the devices of the child configurations of the product, Forward and Reverse Shipping details provide forward and reverse shipping details respectively.
     * @param orderItemName The name of the order item.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Represents order item resource.
     */
    public suspend fun getOrderItem(
        expand: String? = null,
        orderItemName: String,
        resourceGroupName: String,
    ): GetOrderItemResult {
        val argument = GetOrderItemPlainArgs(
            expand = expand,
            orderItemName = orderItemName,
            resourceGroupName = resourceGroupName,
        )
        return getOrderItemResultToKotlin(getOrderItemPlain(argument.toJava()).await())
    }

    /**
     * @see [getOrderItem].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;edgeorder&#46;kotlin&#46;inputs&#46;GetOrderItemPlainArgs].
     * @return Represents order item resource.
     */
    public suspend fun getOrderItem(argument: suspend GetOrderItemPlainArgsBuilder.() -> Unit): GetOrderItemResult {
        val builder = GetOrderItemPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOrderItemResultToKotlin(getOrderItemPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an order item.
     * Azure REST API version: 2021-12-01.
     * @param argument null
     * @return Represents order item contract
     */
    public suspend fun getOrderItemByName(argument: GetOrderItemByNamePlainArgs): GetOrderItemByNameResult =
        getOrderItemByNameResultToKotlin(getOrderItemByNamePlain(argument.toJava()).await())

    /**
     * @see [getOrderItemByName].
     * @param expand $expand is supported on device details, forward shipping details and reverse shipping details parameters. Each of these can be provided as a comma separated list. Device Details for order item provides details on the devices of the product, Forward and Reverse Shipping details provide forward and reverse shipping details respectively.
     * @param orderItemName The name of the order item
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Represents order item contract
     */
    public suspend fun getOrderItemByName(
        expand: String? = null,
        orderItemName: String,
        resourceGroupName: String,
    ): GetOrderItemByNameResult {
        val argument = GetOrderItemByNamePlainArgs(
            expand = expand,
            orderItemName = orderItemName,
            resourceGroupName = resourceGroupName,
        )
        return getOrderItemByNameResultToKotlin(getOrderItemByNamePlain(argument.toJava()).await())
    }

    /**
     * @see [getOrderItemByName].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;edgeorder&#46;kotlin&#46;inputs&#46;GetOrderItemByNamePlainArgs].
     * @return Represents order item contract
     */
    public suspend fun getOrderItemByName(argument: suspend GetOrderItemByNamePlainArgsBuilder.() -> Unit): GetOrderItemByNameResult {
        val builder = GetOrderItemByNamePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOrderItemByNameResultToKotlin(getOrderItemByNamePlain(builtArgument.toJava()).await())
    }

    /**
     * This method provides the list of configurations for the given product family, product line and product under subscription.
     * Azure REST API version: 2021-12-01.
     * Other available API versions: 2020-12-01-preview.
     * @param argument null
     * @return The list of configurations.
     */
    public suspend fun listConfigurations(argument: ListConfigurationsPlainArgs): ListConfigurationsResult =
        listConfigurationsResultToKotlin(listConfigurationsPlain(argument.toJava()).await())

    /**
     * @see [listConfigurations].
     * @param configurationFilters Holds details about product hierarchy information and filterable property.
     * @param customerSubscriptionDetails Customer subscription properties. Clients can display available products to unregistered customers by explicitly passing subscription details
     * @param skipToken $skipToken is supported on list of configurations, which provides the next page in the list of configurations.
     * @return The list of configurations.
     */
    public suspend fun listConfigurations(
        configurationFilters: List<ConfigurationFilters>,
        customerSubscriptionDetails: CustomerSubscriptionDetails? = null,
        skipToken: String? = null,
    ): ListConfigurationsResult {
        val argument = ListConfigurationsPlainArgs(
            configurationFilters = configurationFilters,
            customerSubscriptionDetails = customerSubscriptionDetails,
            skipToken = skipToken,
        )
        return listConfigurationsResultToKotlin(listConfigurationsPlain(argument.toJava()).await())
    }

    /**
     * @see [listConfigurations].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;edgeorder&#46;kotlin&#46;inputs&#46;ListConfigurationsPlainArgs].
     * @return The list of configurations.
     */
    public suspend fun listConfigurations(argument: suspend ListConfigurationsPlainArgsBuilder.() -> Unit): ListConfigurationsResult {
        val builder = ListConfigurationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listConfigurationsResultToKotlin(listConfigurationsPlain(builtArgument.toJava()).await())
    }

    /**
     * This method provides the list of product families for the given subscription.
     * Azure REST API version: 2021-12-01.
     * Other available API versions: 2020-12-01-preview.
     * @param argument null
     * @return The list of product families.
     */
    public suspend fun listProductFamilies(argument: ListProductFamiliesPlainArgs): ListProductFamiliesResult =
        listProductFamiliesResultToKotlin(listProductFamiliesPlain(argument.toJava()).await())

    /**
     * @see [listProductFamilies].
     * @param customerSubscriptionDetails Customer subscription properties. Clients can display available products to unregistered customers by explicitly passing subscription details
     * @param expand $expand is supported on configurations parameter for product, which provides details on the configurations for the product.
     * @param filterableProperties Dictionary of filterable properties on product family.
     * @param skipToken $skipToken is supported on list of product families, which provides the next page in the list of product families.
     * @return The list of product families.
     */
    public suspend fun listProductFamilies(
        customerSubscriptionDetails: CustomerSubscriptionDetails? = null,
        expand: String? = null,
        filterableProperties: Map<String, List<FilterableProperty>>,
        skipToken: String? = null,
    ): ListProductFamiliesResult {
        val argument = ListProductFamiliesPlainArgs(
            customerSubscriptionDetails = customerSubscriptionDetails,
            expand = expand,
            filterableProperties = filterableProperties,
            skipToken = skipToken,
        )
        return listProductFamiliesResultToKotlin(listProductFamiliesPlain(argument.toJava()).await())
    }

    /**
     * @see [listProductFamilies].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;edgeorder&#46;kotlin&#46;inputs&#46;ListProductFamiliesPlainArgs].
     * @return The list of product families.
     */
    public suspend fun listProductFamilies(argument: suspend ListProductFamiliesPlainArgsBuilder.() -> Unit): ListProductFamiliesResult {
        val builder = ListProductFamiliesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listProductFamiliesResultToKotlin(listProductFamiliesPlain(builtArgument.toJava()).await())
    }

    /**
     * List product families for the given subscription.
     * Azure REST API version: 2022-05-01-preview.
     * Other available API versions: 2024-02-01.
     * @param argument null
     * @return The list of product families.
     */
    public suspend fun listProductsAndConfigurationProductFamilies(argument: ListProductsAndConfigurationProductFamiliesPlainArgs): ListProductsAndConfigurationProductFamiliesResult =
        listProductsAndConfigurationProductFamiliesResultToKotlin(listProductsAndConfigurationProductFamiliesPlain(argument.toJava()).await())

    /**
     * @see [listProductsAndConfigurationProductFamilies].
     * @param customerSubscriptionDetails Customer subscription properties. Clients can display available products to unregistered customers by explicitly passing subscription details.
     * @param expand $expand is supported on configurations parameter for product, which provides details on the configurations for the product.
     * @param filterableProperties Dictionary of filterable properties on product family.
     * @param skipToken $skipToken is supported on list of product families, which provides the next page in the list of product families.
     * @return The list of product families.
     */
    public suspend fun listProductsAndConfigurationProductFamilies(
        customerSubscriptionDetails: CustomerSubscriptionDetails? = null,
        expand: String? = null,
        filterableProperties: Map<String, List<FilterableProperty>>,
        skipToken: String? = null,
    ): ListProductsAndConfigurationProductFamiliesResult {
        val argument = ListProductsAndConfigurationProductFamiliesPlainArgs(
            customerSubscriptionDetails = customerSubscriptionDetails,
            expand = expand,
            filterableProperties = filterableProperties,
            skipToken = skipToken,
        )
        return listProductsAndConfigurationProductFamiliesResultToKotlin(listProductsAndConfigurationProductFamiliesPlain(argument.toJava()).await())
    }

    /**
     * @see [listProductsAndConfigurationProductFamilies].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;edgeorder&#46;kotlin&#46;inputs&#46;ListProductsAndConfigurationProductFamiliesPlainArgs].
     * @return The list of product families.
     */
    public suspend fun listProductsAndConfigurationProductFamilies(argument: suspend ListProductsAndConfigurationProductFamiliesPlainArgsBuilder.() -> Unit): ListProductsAndConfigurationProductFamiliesResult {
        val builder = ListProductsAndConfigurationProductFamiliesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listProductsAndConfigurationProductFamiliesResultToKotlin(listProductsAndConfigurationProductFamiliesPlain(builtArgument.toJava()).await())
    }

    /**
     * List configurations for the given product family, product line and product for the given subscription.
     * Azure REST API version: 2022-05-01-preview.
     * Other available API versions: 2024-02-01.
     * @param argument null
     * @return The list of configurations.
     */
    public suspend fun listProductsAndConfigurations(argument: ListProductsAndConfigurationsPlainArgs): ListProductsAndConfigurationsResult =
        listProductsAndConfigurationsResultToKotlin(listProductsAndConfigurationsPlain(argument.toJava()).await())

    /**
     * @see [listProductsAndConfigurations].
     * @param configurationFilter Holds details about product hierarchy information and filterable property.
     * @param customerSubscriptionDetails Customer subscription properties. Clients can display available products to unregistered customers by explicitly passing subscription details.
     * @param skipToken $skipToken is supported on list of configurations, which provides the next page in the list of configurations.
     * @return The list of configurations.
     */
    public suspend fun listProductsAndConfigurations(
        configurationFilter: ConfigurationFilter? = null,
        customerSubscriptionDetails: CustomerSubscriptionDetails? = null,
        skipToken: String? = null,
    ): ListProductsAndConfigurationsResult {
        val argument = ListProductsAndConfigurationsPlainArgs(
            configurationFilter = configurationFilter,
            customerSubscriptionDetails = customerSubscriptionDetails,
            skipToken = skipToken,
        )
        return listProductsAndConfigurationsResultToKotlin(listProductsAndConfigurationsPlain(argument.toJava()).await())
    }

    /**
     * @see [listProductsAndConfigurations].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;edgeorder&#46;kotlin&#46;inputs&#46;ListProductsAndConfigurationsPlainArgs].
     * @return The list of configurations.
     */
    public suspend fun listProductsAndConfigurations(argument: suspend ListProductsAndConfigurationsPlainArgsBuilder.() -> Unit): ListProductsAndConfigurationsResult {
        val builder = ListProductsAndConfigurationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listProductsAndConfigurationsResultToKotlin(listProductsAndConfigurationsPlain(builtArgument.toJava()).await())
    }
}
