@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin

import com.pulumi.azurenative.edgeorder.kotlin.outputs.AddressDetailsResponse
import com.pulumi.azurenative.edgeorder.kotlin.outputs.OrderItemDetailsResponse
import com.pulumi.azurenative.edgeorder.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.edgeorder.kotlin.outputs.AddressDetailsResponse.Companion.toKotlin as addressDetailsResponseToKotlin
import com.pulumi.azurenative.edgeorder.kotlin.outputs.OrderItemDetailsResponse.Companion.toKotlin as orderItemDetailsResponseToKotlin
import com.pulumi.azurenative.edgeorder.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [OrderItemByName].
 */
@PulumiTagMarker
public class OrderItemByNameResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OrderItemByNameArgs = OrderItemByNameArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OrderItemByNameArgsBuilder.() -> Unit) {
        val builder = OrderItemByNameArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): OrderItemByName {
        val builtJavaResource =
            com.pulumi.azurenative.edgeorder.OrderItemByName(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return OrderItemByName(builtJavaResource)
    }
}

/**
 * Represents order item contract
 * Azure REST API version: 2021-12-01. Prior API version in Azure Native 1.x: 2021-12-01.
 * ## Example Usage
 * ### CreateOrderItem
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var orderItemByName = new AzureNative.EdgeOrder.OrderItemByName("orderItemByName", new()
 *     {
 *         AddressDetails = new AzureNative.EdgeOrder.Inputs.AddressDetailsArgs
 *         {
 *             ForwardAddress = new AzureNative.EdgeOrder.Inputs.AddressPropertiesArgs
 *             {
 *                 ContactDetails = new AzureNative.EdgeOrder.Inputs.ContactDetailsArgs
 *                 {
 *                     ContactName = "XXXX XXXX",
 *                     EmailList = new[]
 *                     {
 *                         "xxxx@xxxx.xxx",
 *                     },
 *                     Phone = "0000000000",
 *                     PhoneExtension = "",
 *                 },
 *                 ShippingAddress = new AzureNative.EdgeOrder.Inputs.ShippingAddressArgs
 *                 {
 *                     AddressType = AzureNative.EdgeOrder.AddressType.None,
 *                     City = "San Francisco",
 *                     CompanyName = "Microsoft",
 *                     Country = "US",
 *                     PostalCode = "94107",
 *                     StateOrProvince = "CA",
 *                     StreetAddress1 = "16 TOWNSEND ST",
 *                     StreetAddress2 = "UNIT 1",
 *                 },
 *             },
 *         },
 *         Location = "eastus",
 *         OrderId = "/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/locations/eastus/orders/TestOrderName2",
 *         OrderItemDetails = new AzureNative.EdgeOrder.Inputs.OrderItemDetailsArgs
 *         {
 *             OrderItemType = AzureNative.EdgeOrder.OrderItemType.Purchase,
 *             Preferences = new AzureNative.EdgeOrder.Inputs.PreferencesArgs
 *             {
 *                 TransportPreferences = new AzureNative.EdgeOrder.Inputs.TransportPreferencesArgs
 *                 {
 *                     PreferredShipmentType = AzureNative.EdgeOrder.TransportShipmentTypes.MicrosoftManaged,
 *                 },
 *             },
 *             ProductDetails = new AzureNative.EdgeOrder.Inputs.ProductDetailsArgs
 *             {
 *                 HierarchyInformation = new AzureNative.EdgeOrder.Inputs.HierarchyInformationArgs
 *                 {
 *                     ConfigurationName = "edgep_base",
 *                     ProductFamilyName = "azurestackedge",
 *                     ProductLineName = "azurestackedge",
 *                     ProductName = "azurestackedgegpu",
 *                 },
 *             },
 *         },
 *         OrderItemName = "TestOrderItemName2",
 *         ResourceGroupName = "YourResourceGroupName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/edgeorder/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := edgeorder.NewOrderItemByName(ctx, "orderItemByName", &edgeorder.OrderItemByNameArgs{
 * 			AddressDetails: &edgeorder.AddressDetailsArgs{
 * 				ForwardAddress: &edgeorder.AddressPropertiesArgs{
 * 					ContactDetails: &edgeorder.ContactDetailsArgs{
 * 						ContactName: pulumi.String("XXXX XXXX"),
 * 						EmailList: pulumi.StringArray{
 * 							pulumi.String("xxxx@xxxx.xxx"),
 * 						},
 * 						Phone:          pulumi.String("0000000000"),
 * 						PhoneExtension: pulumi.String(""),
 * 					},
 * 					ShippingAddress: &edgeorder.ShippingAddressArgs{
 * 						AddressType:     pulumi.String(edgeorder.AddressTypeNone),
 * 						City:            pulumi.String("San Francisco"),
 * 						CompanyName:     pulumi.String("Microsoft"),
 * 						Country:         pulumi.String("US"),
 * 						PostalCode:      pulumi.String("94107"),
 * 						StateOrProvince: pulumi.String("CA"),
 * 						StreetAddress1:  pulumi.String("16 TOWNSEND ST"),
 * 						StreetAddress2:  pulumi.String("UNIT 1"),
 * 					},
 * 				},
 * 			},
 * 			Location: pulumi.String("eastus"),
 * 			OrderId:  pulumi.String("/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/locations/eastus/orders/TestOrderName2"),
 * 			OrderItemDetails: &edgeorder.OrderItemDetailsArgs{
 * 				OrderItemType: pulumi.String(edgeorder.OrderItemTypePurchase),
 * 				Preferences: &edgeorder.PreferencesArgs{
 * 					TransportPreferences: &edgeorder.TransportPreferencesArgs{
 * 						PreferredShipmentType: pulumi.String(edgeorder.TransportShipmentTypesMicrosoftManaged),
 * 					},
 * 				},
 * 				ProductDetails: &edgeorder.ProductDetailsArgs{
 * 					HierarchyInformation: &edgeorder.HierarchyInformationArgs{
 * 						ConfigurationName: pulumi.String("edgep_base"),
 * 						ProductFamilyName: pulumi.String("azurestackedge"),
 * 						ProductLineName:   pulumi.String("azurestackedge"),
 * 						ProductName:       pulumi.String("azurestackedgegpu"),
 * 					},
 * 				},
 * 			},
 * 			OrderItemName:     pulumi.String("TestOrderItemName2"),
 * 			ResourceGroupName: pulumi.String("YourResourceGroupName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.edgeorder.OrderItemByName;
 * import com.pulumi.azurenative.edgeorder.OrderItemByNameArgs;
 * import com.pulumi.azurenative.edgeorder.inputs.AddressDetailsArgs;
 * import com.pulumi.azurenative.edgeorder.inputs.AddressPropertiesArgs;
 * import com.pulumi.azurenative.edgeorder.inputs.ContactDetailsArgs;
 * import com.pulumi.azurenative.edgeorder.inputs.ShippingAddressArgs;
 * import com.pulumi.azurenative.edgeorder.inputs.OrderItemDetailsArgs;
 * import com.pulumi.azurenative.edgeorder.inputs.PreferencesArgs;
 * import com.pulumi.azurenative.edgeorder.inputs.TransportPreferencesArgs;
 * import com.pulumi.azurenative.edgeorder.inputs.ProductDetailsArgs;
 * import com.pulumi.azurenative.edgeorder.inputs.HierarchyInformationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var orderItemByName = new OrderItemByName("orderItemByName", OrderItemByNameArgs.builder()
 *             .addressDetails(AddressDetailsArgs.builder()
 *                 .forwardAddress(AddressPropertiesArgs.builder()
 *                     .contactDetails(ContactDetailsArgs.builder()
 *                         .contactName("XXXX XXXX")
 *                         .emailList("xxxx@xxxx.xxx")
 *                         .phone("0000000000")
 *                         .phoneExtension("")
 *                         .build())
 *                     .shippingAddress(ShippingAddressArgs.builder()
 *                         .addressType("None")
 *                         .city("San Francisco")
 *                         .companyName("Microsoft")
 *                         .country("US")
 *                         .postalCode("94107")
 *                         .stateOrProvince("CA")
 *                         .streetAddress1("16 TOWNSEND ST")
 *                         .streetAddress2("UNIT 1")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .location("eastus")
 *             .orderId("/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/locations/eastus/orders/TestOrderName2")
 *             .orderItemDetails(OrderItemDetailsArgs.builder()
 *                 .orderItemType("Purchase")
 *                 .preferences(PreferencesArgs.builder()
 *                     .transportPreferences(TransportPreferencesArgs.builder()
 *                         .preferredShipmentType("MicrosoftManaged")
 *                         .build())
 *                     .build())
 *                 .productDetails(ProductDetailsArgs.builder()
 *                     .hierarchyInformation(HierarchyInformationArgs.builder()
 *                         .configurationName("edgep_base")
 *                         .productFamilyName("azurestackedge")
 *                         .productLineName("azurestackedge")
 *                         .productName("azurestackedgegpu")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .orderItemName("TestOrderItemName2")
 *             .resourceGroupName("YourResourceGroupName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:edgeorder:OrderItemByName TestOrderItemName2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/orderItems/{orderItemName}
 * ```
 */
public class OrderItemByName internal constructor(
    override val javaResource: com.pulumi.azurenative.edgeorder.OrderItemByName,
) : KotlinCustomResource(javaResource, OrderItemByNameMapper) {
    /**
     * Represents shipping and return address for order item
     */
    public val addressDetails: Output<AddressDetailsResponse>
        get() = javaResource.addressDetails().applyValue({ args0 ->
            args0.let({ args0 ->
                addressDetailsResponseToKotlin(args0)
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Id of the order to which order item belongs to
     */
    public val orderId: Output<String>
        get() = javaResource.orderId().applyValue({ args0 -> args0 })

    /**
     * Represents order item details.
     */
    public val orderItemDetails: Output<OrderItemDetailsResponse>
        get() = javaResource.orderItemDetails().applyValue({ args0 ->
            args0.let({ args0 ->
                orderItemDetailsResponseToKotlin(args0)
            })
        })

    /**
     * Start time of order item
     */
    public val startTime: Output<String>
        get() = javaResource.startTime().applyValue({ args0 -> args0 })

    /**
     * Represents resource creation and update time
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object OrderItemByNameMapper : ResourceMapper<OrderItemByName> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.edgeorder.OrderItemByName::class == javaResource::class

    override fun map(javaResource: Resource): OrderItemByName = OrderItemByName(
        javaResource as
            com.pulumi.azurenative.edgeorder.OrderItemByName,
    )
}

/**
 * @see [OrderItemByName].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OrderItemByName].
 */
public suspend fun orderItemByName(
    name: String,
    block: suspend OrderItemByNameResourceBuilder.() -> Unit,
): OrderItemByName {
    val builder = OrderItemByNameResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OrderItemByName].
 * @param name The _unique_ name of the resulting resource.
 */
public fun orderItemByName(name: String): OrderItemByName {
    val builder = OrderItemByNameResourceBuilder()
    builder.name(name)
    return builder.build()
}
