@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Name of the stage.
 */
public enum class NotificationStageName(
    public val javaValue: com.pulumi.azurenative.edgeorder.enums.NotificationStageName,
) : ConvertibleToJava<com.pulumi.azurenative.edgeorder.enums.NotificationStageName> {
    /**
     * Notification at order item shipped from microsoft datacenter.
     */
    Shipped(com.pulumi.azurenative.edgeorder.enums.NotificationStageName.Shipped),

    /**
     * Notification at order item delivered to customer.
     */
    Delivered(com.pulumi.azurenative.edgeorder.enums.NotificationStageName.Delivered),
    ;

    override fun toJava(): com.pulumi.azurenative.edgeorder.enums.NotificationStageName = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.edgeorder.enums.NotificationStageName): NotificationStageName = NotificationStageName.values().first { it.javaValue == javaType }
    }
}
