@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Indicates Shipment Logistics type that the customer preferred.
 */
public enum class TransportShipmentTypes(
    public val javaValue: com.pulumi.azurenative.edgeorder.enums.TransportShipmentTypes,
) : ConvertibleToJava<com.pulumi.azurenative.edgeorder.enums.TransportShipmentTypes> {
    /**
     * Shipment Logistics is handled by the customer.
     */
    CustomerManaged(com.pulumi.azurenative.edgeorder.enums.TransportShipmentTypes.CustomerManaged),

    /**
     * Shipment Logistics is handled by Microsoft.
     */
    MicrosoftManaged(com.pulumi.azurenative.edgeorder.enums.TransportShipmentTypes.MicrosoftManaged),
    ;

    override fun toJava(): com.pulumi.azurenative.edgeorder.enums.TransportShipmentTypes = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.edgeorder.enums.TransportShipmentTypes): TransportShipmentTypes = TransportShipmentTypes.values().first { it.javaValue == javaType }
    }
}
