@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.inputs

import com.pulumi.azurenative.edgeorder.inputs.AddressPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Address Properties
 * @property contactDetails Contact details for the address
 * @property shippingAddress Shipping details for the address
 */
public data class AddressPropertiesArgs(
    public val contactDetails: Output<ContactDetailsArgs>,
    public val shippingAddress: Output<ShippingAddressArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.edgeorder.inputs.AddressPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.edgeorder.inputs.AddressPropertiesArgs =
        com.pulumi.azurenative.edgeorder.inputs.AddressPropertiesArgs.builder()
            .contactDetails(contactDetails.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .shippingAddress(
                shippingAddress?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [AddressPropertiesArgs].
 */
@PulumiTagMarker
public class AddressPropertiesArgsBuilder internal constructor() {
    private var contactDetails: Output<ContactDetailsArgs>? = null

    private var shippingAddress: Output<ShippingAddressArgs>? = null

    /**
     * @param value Contact details for the address
     */
    @JvmName("baqqmhgfwondioya")
    public suspend fun contactDetails(`value`: Output<ContactDetailsArgs>) {
        this.contactDetails = value
    }

    /**
     * @param value Shipping details for the address
     */
    @JvmName("ktnvfeqvxclkevdl")
    public suspend fun shippingAddress(`value`: Output<ShippingAddressArgs>) {
        this.shippingAddress = value
    }

    /**
     * @param value Contact details for the address
     */
    @JvmName("cteppepejeghrgvs")
    public suspend fun contactDetails(`value`: ContactDetailsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contactDetails = mapped
    }

    /**
     * @param argument Contact details for the address
     */
    @JvmName("vudvwdkfacielhua")
    public suspend fun contactDetails(argument: suspend ContactDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = ContactDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.contactDetails = mapped
    }

    /**
     * @param value Shipping details for the address
     */
    @JvmName("dkfsckcxtesykpcx")
    public suspend fun shippingAddress(`value`: ShippingAddressArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shippingAddress = mapped
    }

    /**
     * @param argument Shipping details for the address
     */
    @JvmName("wlbbsfabrpuonemn")
    public suspend fun shippingAddress(argument: suspend ShippingAddressArgsBuilder.() -> Unit) {
        val toBeMapped = ShippingAddressArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.shippingAddress = mapped
    }

    internal fun build(): AddressPropertiesArgs = AddressPropertiesArgs(
        contactDetails = contactDetails ?: throw PulumiNullFieldException("contactDetails"),
        shippingAddress = shippingAddress,
    )
}
